<?php

// =============================================================================
// INCLUDE REQUIRED FILES
// =============================================================================
require_once 'settings.php';      // Main configuration and translations
require_once 'functions.php'; // User management and utility functions
require_once 'parser.php'; // Custom content parsing system
// require_once 'landing.php';       // Old landing page content (deprecated)

// =============================================================================
// SESSION MANAGEMENT
// =============================================================================
session_start(); // Start PHP session for user login state and language preference

// =============================================================================
// LANGUAGE DETECTION AND CONTENT LOADING
// =============================================================================

// Language setup (single-language mode)
$lang = get_default_lang();

// Load content using new custom content management system
$content_data = getProcessedContent($lang);
$landing_title = $content_data['title'] ?? 'Welcome';           // Page title
$landing_content = $content_data['content'] ?? '';              // Processed HTML content

// =============================================================================
// FALLBACK CONTENT HANDLING
// =============================================================================

// If no content is available, show fallback
if (empty($landing_content)) {
    $landing_content = '<p>Welcome to ' . getSetting('SITE_SETTINGS.site_name', 'Principles') . '!</p><p>Edit fpeng.txt or fpother.txt to customize this content.</p>';
}

?>
<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo t('prescription'); ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="style.php">
    <?php echo getContentStyles(); ?>
</head>
<body class="prescription-page">
    <!-- Navigation -->
    <nav class="navbar">
        <div class="nav-container nav-flex">
            <div class="nav-left">
                <a href="index.php" class="nav-button"><?php echo t('prescription', $lang); ?></a>
                <a href="principles.php" class="nav-button"><?php echo t('principles', $lang); ?></a>
                <a href="walkers.php" class="nav-button"><?php echo t('walkers', $lang); ?></a>
                <?php if (isLoggedIn()): ?>
                    <a href="profile.php" class="nav-button profile-btn"><?php echo t('profile', $lang); ?></a>
                <?php else: ?>
                    <a href="go.php" class="nav-button login-btn"><?php echo t('login_signup_topbar', $lang); ?></a>
                <?php endif; ?>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="main-content">
        <div class="container">
            <div class="prescription-content">
                <h1 class="landing-title"><?php echo htmlspecialchars($landing_title); ?></h1>
                <?php echo $landing_content; ?>
            </div>
        </div>
    </main>
</body>
</html>
